@echo off

rem PC-FX Tyoushin Heiki Zeroigar : English Translation patch v1.0.1
rem 
rem Please see README.TXT for instructions.

setlocal

set ROOT_DIR=%cd%

set PATH=%cd%\english-patch;%PATH%

set SRC_BIN_FILE=
set SRC_CUE_FILE=

for %%i in (original-cd\*.bin) do set SRC_BIN_FILE=%%i
for %%i in (original-cd\*.cue) do set SRC_CUE_FILE=%%i

rem
rem Extract the .bin file into the component .iso/.wav files.
rem

:extract_bin

if not defined SRC_BIN_FILE goto :copy_turborip
if not defined SRC_CUE_FILE goto :no_original

echo.
echo Using BIN file "%SRC_BIN_FILE%"
echo Using CUE file "%SRC_CUE_FILE%"
echo.

cd english-cd || goto :failed

if exist "zeroigar*.*" del /q "zeroigar*.*" || goto :failed

bchunk.exe -v -w "..\%SRC_BIN_FILE%" "..\%SRC_CUE_FILE%" zeroigar || goto :failed

echo.

goto :test_original

rem
rem Copy the already-extracted component .iso/.wav files.
rem

:copy_turborip

set SRC_TRACK1_FILE=
set SRC_TRACK2_FILE=
set SRC_TRACK3_FILE=
set SRC_TRACK4_FILE=
set SRC_TRACK5_FILE=

for %%i in (original-cd\*.wav) do call :identify_file "%%i"
for %%i in (original-cd\*.iso) do call :identify_file "%%i"

if not defined SRC_TRACK1_FILE goto :no_original
if not defined SRC_TRACK2_FILE goto :no_original
if not defined SRC_TRACK3_FILE goto :no_original
if not defined SRC_TRACK4_FILE goto :no_original
if not defined SRC_TRACK5_FILE goto :no_original

echo.
echo Using TRACK 1 file "%SRC_TRACK1_FILE%"
echo Using TRACK 2 file "%SRC_TRACK2_FILE%"
echo Using TRACK 3 file "%SRC_TRACK3_FILE%"
echo Using TRACK 4 file "%SRC_TRACK4_FILE%"
echo Using TRACK 5 file "%SRC_TRACK5_FILE%"
echo.

cd english-cd || goto :failed

if exist "zeroigar*.*" del /q "zeroigar*.*" || goto :failed

echo Copying files to the "english-cd" folder ...
echo.

copy "..\%SRC_TRACK1_FILE%" zeroigar01.wav || goto :failed
copy "..\%SRC_TRACK2_FILE%" zeroigar02.iso || goto :failed
copy "..\%SRC_TRACK3_FILE%" zeroigar03.wav || goto :failed
copy "..\%SRC_TRACK4_FILE%" zeroigar04.wav || goto :failed
copy "..\%SRC_TRACK5_FILE%" zeroigar05.wav || goto :failed

goto :test_original

rem
rem We should now have a set of extracted files in the "english-cd" folder.
rem

:test_original

call :check_size zeroigar01.wav   4132508 || goto :bad_original
call :check_size zeroigar02.iso 365950976 || goto :bad_original
call :check_size zeroigar03.wav  29990396 || goto :bad_original
call :check_size zeroigar04.wav  47277596 || goto :bad_original
call :check_size zeroigar05.wav 130472540 || goto :bad_original

if exist zeroigar02.iso.original del /q zeroigar02.iso.original

copy ..\english-patch\cue\zeroigar.cue zeroigar.cue || goto :failed 

copy zeroigar02.iso zeroigar02.iso.original || goto :failed

cd ..\english-patch

echo.
echo.
echo.

zero-mix.exe || goto :failed

echo.
echo.
echo.

zero-patch.exe || goto :failed

cd ..\english-cd

del /q zeroigar02.iso.original || goto :failed

rem echo.
rem echo.
echo.

dir

echo.
echo We hope that you enjoy your English version of "God-Fighter Zeroigar"!
echo.
echo !!! PLEASE DO NOT MAKE/SELL REPRODUCTIONS OF THIS TRANSLATION !!!
echo.
echo This Translation Patch includes copyrighted program code that is licensed
echo to you for Non-Commercial use only.  Please read the manual for more info.
echo.

pause

exit /b 0

:failed

del /q "%ROOT_DIR%\english-cd\zeroigar*.*" >nul 2>&1

echo.
echo.
echo.
echo The patching process failed ... please read the text above to see why!
echo.

pause

exit /b 1

rem
rem
rem

:identify_file

if %~z1 equ   4132508 set SRC_TRACK1_FILE=%~1
if %~z1 equ 365950976 set SRC_TRACK2_FILE=%~1
if %~z1 equ  29990396 set SRC_TRACK3_FILE=%~1
if %~z1 equ  47277596 set SRC_TRACK4_FILE=%~1
if %~z1 equ 130472540 set SRC_TRACK5_FILE=%~1

exit /b 0

rem
rem
rem

:check_size

if not exist %1 goto :missing_file

if %~z1 equ %2 exit /b 0

echo.
echo The extracted file "%1" should be %2 bytes long.
echo.
echo It is actually %~z1 bytes long.

exit /b 1

:missing_file

echo.
echo The extracted file %1 is missing!

exit /b 1

rem
rem
rem

:bad_original

echo.
echo Please check that you're using a known-good copy of the original Zeroigar
echo CD image in either ".cue/.bin" or ".cue/.wav/.iso" format.
echo.

goto :failed

rem
rem
rem

:no_original

echo.
echo Could not find the original Zeroigar CD image files in the "original-cd"
echo folder!
echo.
echo Please acquire a known-good copy of the original Zeroigar CD image, in
echo either ".cue/.bin" or ".cue/.wav/.iso" format, and then put the files
echo into the "original-cd" folder.
echo.
echo Then you'll be ready to try again!
echo.
echo You can find more instructions in the documentation that accompanies
echo the translation patch.

goto :failed
